/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.
//
// Somewhat more than the normal modifications were needed for this ShaderToy
// adaption due to the way in which video inputs are handled and the use of a
// transparent area in VGHD clips. TheEmu.
//
// The results are not quite as effective with VGHD clips as the original was
// with its test video,  but it is still an interresting effect and it may be
// possible to tune it to better suit VGHD clips.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

/////////////////////////////////////////////////////////////////////////////////

const float k1 = 0.995;
const float k2 = 0.550;
const float k3 = 1.250;
const float k4 = 0.090;

const vec3 c0 = vec3 ( 0.5, 0.3, 0.4 );

void main ( void )
{
   float a = texture2D(iChannel0,gl_TexCoord[0].xy).a;
	vec3  p = gl_TexCoord[0].xyz - c0;
   p.xy *= k1;
   vec4  t = texture2D(iChannel0,c0.xy+p.xy);
   vec3  o = t.rbb;

	for (int i=0; i<50; i++) 
   { p.xy *= k1;
     t = texture2D(iChannel0,c0.xy+p.xy);
     if ( t.a > 0.0 ) p.z += pow(max(0.0,k2-length(t.rg)),k3) * exp(-float(i)*k4);
   }

	gl_FragColor=vec4(o*o+p.z,a);

}
